﻿package 
{
	//importing the main classes
	import flash.display.*;
	import flash.geom.*;
	import flash.media.*;
    import flash.net.*;
	import flash.events.*;
	import flash.ui.ContextMenuBuiltInItems;
	import flash.utils.*;
    import flash.xml.*;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.*;
	import flash.ui.Mouse;
	import flash.text.*;
	public class Wall extends MovieClip
	{
		//for xml loading
		public var xmlLoader:URLLoader = new URLLoader()
		public var xml:XML;
		private var feed:String = "";
		
		private var i:int = 0;
		private var assetCon:MovieClip = new MovieClip();
		private var overLayer:MovieClip = new MovieClip();
		private var assetPosX:int = 0;
		private var assetPosY:int = 0;
		
		private var viewIndexX:int = 0;
		private var viewIndexY:int = 0;
		private var rotateIndexX:Number = 0;
		private var rotateIndexY:Number = 0;
		private var conWidth:int = 0;
		private var conHeight:int = 0;
		
		private var addedX:Boolean = false;
		private var addedY:Boolean = false;
		private var assetCenterX:int = 0;
		private var assetCenterY:int = 0;
		
		private var controls_mc:MovieClip = new Controls();
		
		private var currAsset:MovieClip = null;
		private var currMedia:MovieClip = null;
		
		private var assetXArray:Array = new Array();
		private var assetYArray:Array = new Array();
		
		private var currAssetWidth:int = 0;
		private var currAssetHeight:int = 0;
		private var currAssetIndex:int = -1;
		private var busy:Boolean = false;
		private var veryBusy:Boolean = false;
		
		private var lastMouseX:int = 0;
		private var lastMouseY:int = 0;
		private var targetMouseX:int = 0;
		private var targetMouseY:int = 0;
		private var tempIndex:int = 0;
		private var zoomIndex:Number = 1.5;
		
		public var moveBuffer:int = 0;
		public var moveIndex:int = 0;
		private var currLink:String = "";
		private var adr:String = "0";
		
		public var totalWidth:int = 800;
		public var totalHeight:int = 800;
		public var allStage:Boolean = true;
		
		public function Wall (pfeed:String = "menu.xml")
		{
			feed = pfeed;
			
			// we init the shortcuts from caurina
			DisplayShortcuts.init();
			FilterShortcuts.init();
			ColorShortcuts.init();
			
			visible = false;
			if(stage==null)
			addEventListener(Event.ADDED_TO_STAGE, init);
			else
			init(null);
		}
		private function init(e:Event)
		{
			//setting up the stage to scale proper
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.showDefaultContextMenu = false;
			
			//and xml function
			xmlLoader.addEventListener(Event.COMPLETE, handleXML);
			xmlLoader.load(new URLRequest(feed));
			
		}
		private function handleResize(e:Event)
		{
			//resize function for the wall
			//____________________________
			

			if (stage == null)
			{
				//if stage is null we won't know the stage size thus this function has no sense
			}
			else
			{
			//real function begins here
			//*************************
			if (allStage == true)
			{
			totalWidth = stage.stageWidth;
			totalHeight = stage.stageHeight;
			}
			
			if (conWidth > totalWidth)
			{
			if (addedX == false)
			{
			addedX = true;
			addEventListener(Event.ENTER_FRAME, handleFrameX);
			}
			}
			else
			{
				removeEventListener(Event.ENTER_FRAME, handleFrameX);
				addedX = false;
				viewIndexX = (totalWidth >> 1) - (conWidth >> 1);
				
				overLayer.x = viewIndexX;
				
				Tweener.addTween(assetCon, { x:viewIndexX, rotationY:0, time:.7 } );
			}
			
			if (conHeight > totalHeight)
			{
			if (addedY == false)
			{
			addedY = true;
			addEventListener(Event.ENTER_FRAME, handleFrameY);
			}
			}
			else
			{
				removeEventListener(Event.ENTER_FRAME, handleFrameY);
				addedY = false;
				viewIndexY = (totalHeight >> 1) - (conHeight >> 1);
				
				overLayer.y = viewIndexY;
				
				
				Tweener.addTween(assetCon, { y:viewIndexY, rotationX:0, time:.7 } );
			}
			//resize the controls
			//___________________
			controls_mc.left_mc.y = (totalHeight >> 1) - (controls_mc.left_mc.height >> 1);
			controls_mc.right_mc.y = (totalHeight >> 1) - (controls_mc.left_mc.height >> 1);
			controls_mc.right_mc.x = totalWidth;
			controls_mc.bg_mc.width = totalWidth;
			controls_mc.bg_mc.height = totalHeight;
			
			if (busy == true)
			{
				viewIndexX = (lastMouseX / totalWidth) * -(conWidth - totalWidth + int(xml.settings.@scrollOffset)*2 + int(xml.settings.@errorOffset)*2) + int(xml.settings.@scrollOffset) + int(xml.settings.@errorOffset);
			
			
				if (viewIndexX > int(xml.settings.@scrollOffset)) viewIndexX = int(xml.settings.@scrollOffset);
				if (viewIndexX < -(conWidth - totalWidth + int(xml.settings.@scrollOffset))) viewIndexX = -(conWidth - totalWidth + int(xml.settings.@scrollOffset));
				Tweener.addTween(assetCon, { x:viewIndexX, time:0 } );
				
				
				
				overLayer.x = viewIndexX;
				
				
				viewIndexY = (lastMouseY / totalHeight) * -(conHeight - totalHeight + int(xml.settings.@scrollOffset)*2 + int(xml.settings.@errorOffset)*2) + int(xml.settings.@scrollOffset) + int(xml.settings.@errorOffset);
			
				if (viewIndexY > int(xml.settings.@scrollOffset)) viewIndexY = int(xml.settings.@scrollOffset);
				if (viewIndexY < -(conHeight - totalHeight + int(xml.settings.@scrollOffset))) viewIndexY = -(conHeight - totalHeight + int(xml.settings.@scrollOffset));
				
				Tweener.addTween(assetCon, { y:viewIndexY, time:0 } );
				
				
				
				overLayer.y = viewIndexY;
			}
			if (veryBusy == true)
			{
				currMedia.x = totalWidth >> 1;
				currMedia.y = totalHeight >> 1;
			}
			}
		}
		private function handleXML(e:Event)
		{
			xml = new XML(e.target.data);
			
			conWidth = int(xml.settings.@maxThumbsRow) * int(xml.settings.@thumbSpaceX);
			//we make it visible after the xml has been loaded
			addChild(assetCon);
			assetPosX = 0;
			
			if (allStage == false)
			{
			var masker:Sprite = new Sprite();
			masker.graphics.beginFill(0x000000);
			masker.graphics.drawRect(0, 0, totalWidth, totalHeight);
			addChild(masker);
			mask = masker;
			}
			
			
			
			
			for (i = 0; i < xml.item.length(); i++)
			{
				//loading the assets
				var asset_mc:Asset = new Asset(xml.item[i].thumbnail, xml.settings.@thumbWidth, xml.settings.@thumbHeight,xml.item[i].type,xml.settings.@bordersNormalColor,xml.settings.@normalBordersWidth);
				
				asset_mc.x = assetPosX;
				asset_mc.y = assetPosY;
				assetPosX += int(xml.settings.@thumbSpaceX);
				if (assetPosX >= int(xml.settings.@thumbSpaceX) * int(xml.settings.@maxThumbsRow))
				{
					assetPosX = 0;
					assetPosY += int(xml.settings.@thumbSpaceY);
				}
				asset_mc.mouseChildren = false;
				asset_mc.buttonMode = true;
				
				//we memorize the position
				assetXArray.push(asset_mc.x);
				assetYArray.push(asset_mc.y);
				
				asset_mc.index = i;
				asset_mc.feed = xml.item[i].file;
				asset_mc.type = xml.item[i].type;
				asset_mc.description = xml.item[i].description;
				
				asset_mc.alpha = Number(xml.settings.@normalAlpha);
				
				assetCon.addChild(asset_mc);
				
				asset_mc.addEventListener(MouseEvent.ROLL_OVER, handleAssetMouse);
				asset_mc.addEventListener(MouseEvent.ROLL_OUT, handleAssetMouse);
				asset_mc.addEventListener(MouseEvent.CLICK, handleAssetMouse);
			}
			//we remember the width and height for rotation and moving
			conWidth = assetCon.width;
			conHeight = assetCon.height;
			
			addChild(controls_mc);
			Tweener.addTween(controls_mc, { _autoAlpha:0, time:0 } );
			addChild(overLayer);
			handleResize(null);
			stage.addEventListener(Event.RESIZE, handleResize);
			
			//we comment this because we don't need if for now
			//addEventListener(Event.ENTER_FRAME, handleFrame);
			
			visible = true;
			
			controls_mc.right_mc.buttonMode = true;
			controls_mc.left_mc.buttonMode = true;
			
			//we add actions to our buttons
			controls_mc.right_mc.addEventListener(MouseEvent.MOUSE_DOWN, handleAssetMouse);
			controls_mc.left_mc.addEventListener(MouseEvent.MOUSE_DOWN, handleAssetMouse);
			addEventListener(Event.REMOVED_FROM_STAGE, destroyWall);
			SWFAddress.addEventListener(SWFAddressEvent.CHANGE, handleSWFAddress);
			
		}
		public function handleFrame(e:Event)
		{
			overLayer.x = viewIndexX;
			overLayer.y = viewIndexY;
		}
		public function handleFrameX(e:Event)
		{
			//handle the rotation and movement on the X axis
			if (busy == false)
			{
			viewIndexX = (mouseX / totalWidth) * -(conWidth - totalWidth + int(xml.settings.@scrollOffset)*2 + int(xml.settings.@errorOffset)*2) + int(xml.settings.@scrollOffset) + int(xml.settings.@errorOffset);
			
			
			if (viewIndexX > int(xml.settings.@scrollOffset)) viewIndexX = int(xml.settings.@scrollOffset);
			if (viewIndexX < -(conWidth - totalWidth + int(xml.settings.@scrollOffset))) viewIndexX = -(conWidth - totalWidth + int(xml.settings.@scrollOffset));
			Tweener.addTween(assetCon, { x:viewIndexX, time:1 } );
			
			rotateIndexX = (viewIndexX - int(assetCon.x)) >> 5;
			
			
			Tweener.addTween(assetCon, { rotationY:rotateIndexX, time:0.7 } );
			
			lastMouseX = mouseX;
			overLayer.x = viewIndexX;
			}
			else
			{
				Tweener.addTween(assetCon, { rotationY:0, time:0.7 } );
			
			}
		}
		public function handleFrameY(e:Event)
		{
			//handle the rotation and movement on the Y axis
			if (busy == false)
			{
			viewIndexY = (mouseY / totalHeight) * -(conHeight - totalHeight + int(xml.settings.@scrollOffset)*2 + int(xml.settings.@errorOffset)*2) + int(xml.settings.@scrollOffset) + int(xml.settings.@errorOffset);
			
			if (viewIndexY > int(xml.settings.@scrollOffset)) viewIndexY = int(xml.settings.@scrollOffset);
			if (viewIndexY < -(conHeight - totalHeight + int(xml.settings.@scrollOffset))) viewIndexY = -(conHeight - totalHeight + int(xml.settings.@scrollOffset));
			
			Tweener.addTween(assetCon, { y:viewIndexY, time:1 } );
			rotateIndexY = (viewIndexY - int(assetCon.y)) >> 5;
			
			
			Tweener.addTween(assetCon, { rotationX:rotateIndexY, time:0.7 } );
			
			lastMouseY = mouseY;
			overLayer.y = viewIndexY;
			}
			else
			{
				
				Tweener.addTween(assetCon, { rotationX:0, time:0.7 } );
				
			}
		}
		private function handleAssetMouse(e:MouseEvent)
		{
			
			//handle the mouse Events on the wall assets
			if (e.currentTarget != currAsset)
			{
			if (e.type == "rollOver")
			{
				Tweener.addTween(e.currentTarget, { alpha : Number(xml.settings.@rollAlpha), time:1 } );
				Tweener.addTween(e.currentTarget.borders, { _color:uint(xml.settings.@bordersRollOverColor), time:1 } );
			}
			if (e.type == "rollOut")
			{
				Tweener.addTween(e.currentTarget, { alpha : Number(xml.settings.@normalAlpha), time:1 } );
				Tweener.addTween(e.currentTarget.borders, { _color:uint(xml.settings.@bordersNormalColor), time:1 } );
			}
			if (e.type == "click")
			{
				
				
				openDetails(e.currentTarget.index);
				
				
				//
			}
			if (e.type == "mouseDown")
			{
				if (e.currentTarget.name == "right_mc")
				{
					
					if (veryBusy == false)
					{
					gotoNext();
					}
					else
					{
						closeMedia();
						moveBuffer = 1;
					}
				}
				if (e.currentTarget.name == "left_mc")
				{
					
					if (veryBusy == false)
					{
					gotoPrev();
					}
					else
					{
						closeMedia();
						moveBuffer = -1;
					}
				}
			}
			
			}
		}
		private function openDetails(arg:int)
		{
			//this function opens a media for preview
			for (i = 0; i < assetCon.numChildren; i++)
			{
				
				if (Asset(assetCon.getChildAt(i)).index == arg)
				{
					currAsset = MovieClip(assetCon.getChildAt(i));
				}
			}
			
				
				currAsset.alpha = Number(xml.settings.@rollAlpha);
				currAssetIndex = arg;
			//we calculate the center of the stage relative to the asset	
				assetCenterX = (totalWidth / 2) - viewIndexX + int(xml.settings.@thumbWidth)*0.5 * zoomIndex;
				assetCenterY = totalHeight / 2 - viewIndexY - int(xml.settings.@thumbHeight) * 0.5 * zoomIndex;
				
				assetCon.removeChild(DisplayObject(currAsset));
				overLayer.addChild(DisplayObject(currAsset));
				busy = true;
				currAsset.resizeBorders(int(xml.settings.@selectedBordersWidth) / zoomIndex);
				Tweener.addTween(controls_mc, { _autoAlpha:1, time:1 } );
				//assetCon.setChildIndex(DisplayObject(currAsset), assetCon.numChildren - 1);
				Tweener.addTween(currAsset.bmp, { alpha:0, time:.7 } );
				
				Tweener.addTween(currAsset, { x:assetCenterX, y:assetCenterY, scaleX:zoomIndex, scaleY:zoomIndex, rotationY:180, time:1.4, onComplete:openMedia, onCompleteParams:[int(xml.settings.@thumbWidth) * zoomIndex, int(xml.settings.@thumbHeight) * zoomIndex, currAsset.feed, currAsset.type, currAsset.description] } );
				
				Tweener.addTween(currAsset.borders, { _color:uint(xml.settings.@bordersNormalColor), time:1 } );
				
				
		}
		private function closeDetails()
		{
			
		
			//we close the details
			currAsset.visible = true;
			
			busy = false;
			overLayer.removeChild(currAsset);
					assetCon.addChild(currAsset);
					assetCon.setChildIndex(currAsset, assetCon.numChildren - 1);
					
					currAsset.resizeBorders(Number(xml.settings.@normalBordersWidth));
					currAsset.alpha = 0.8;
					
					Tweener.addTween(controls_mc, { _autoAlpha:0, time:1 } );
					Tweener.addTween(currAsset.bmp, { alpha:1, time:1 } );
					
					Tweener.addTween(currAsset, { x:assetXArray[currAssetIndex], y:assetYArray[currAssetIndex], scaleX:1, scaleY:1, rotationY:0, time:1.4 } );
					
					currAsset = null;
					
			
		}
		
		public function openMedia(w:int, h:int,pfeed:String,ptype:String,pdes:String)
		{
			//we open the media at the requested values
			currAsset.visible = false;
			
			var media_mc:MediaOpen = new MediaOpen(String(pfeed),String(ptype),pdes,w,h);
			media_mc.x = totalWidth / 2;
			media_mc.y = totalHeight / 2;
			media_mc.addEventListener("destroyed", handleMediaClose);
			veryBusy = true;
			
			addChild(media_mc);
			currMedia = media_mc;
			
			
			currLink = String(currAssetIndex);
				
			SWFAddress.setValue(currLink);
		}
		public function closeMedia()
		{
			//function which destroys the current media
			if (currMedia != null)
			{
			if (currMedia.added=="true")
			{
				
				currMedia.destroy();
				
			}
			}
		}
		private function handleMediaClose(e:Event)
		{
			//we close the media and calculate the buffer
			
			//BUFFER 
			//1 -> next
			//0 -> nothing
			//-1 ->prev
			//3 -> close
			//4 -> go to swf adress value
			currAsset.visible = true;
			veryBusy = false;
			if (moveBuffer == 1)
			{
				moveBuffer = 0;
				gotoNext();
			}
			if (moveBuffer == -1)
			{
				moveBuffer = 0;
				gotoPrev();
			}
			if (moveBuffer == 3)
			{
				moveBuffer = 0;
				closeDetails();
				currLink = "";
				SWFAddress.setValue("/");
			}
			if (moveBuffer == 4)
			{
				moveBuffer = 0;
				closeDetails();
				openDetails(int(adr));
			}
		}
		private function gotoNext()
		{
			//close and go to the next
			tempIndex = currAssetIndex + 1;
					if (tempIndex == xml.item.length())
					{
						tempIndex = 0;
					}
					
					closeDetails();
					openDetails(tempIndex);
		}
		private function gotoPrev()
		{
			//close and go the the previous
			tempIndex = currAssetIndex - 1;
					if (tempIndex == -1)
					{
						tempIndex = xml.item.length()-1;
					}
					
					closeDetails();
					openDetails(tempIndex);
		}
		
		public function handleSWFAddress(e:SWFAddressEvent)
		{
			//this function handles the SWF adress
			adr = String(SWFAddress.getValue()).slice(1);
			if (adr != currLink)
			{
			if (adr != '')
			{
				if (busy == false)
				{
				openDetails(int(adr));
				}
				
				if (busy == true)
				{
					closeDetails();
					openDetails(int(adr));
				}
				if (veryBusy == true)
				{
					moveBuffer = 4;
					currMedia.destroy();
					
				}
			}
			else
			{
				if (busy == true)
				{
					closeDetails();
				}
				if (veryBusy == true)
				{
					moveBuffer = 3;
					currMedia.destroy();
					
				}
			}
			}
			
		}
		public function destroyWall(e:Event)
		{
			removeEventListener(Event.ENTER_FRAME, handleFrameX);
			removeEventListener(Event.ENTER_FRAME, handleFrameY);
			SWFAddress.removeEventListener(SWFAddressEvent.CHANGE, handleSWFAddress);
			
			
		}
		
		
		
			
		
	}
}